/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.ViewSimple;
import cds.aladin.ZoomView;
import cds.tools.Astrodate;
import cds.tools.Util;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;

class ZoomTime {
    static final int HEIGHT = 15;
    static final int DELTAY = 48;
    static final int DELTA_G = 7;
    static final int DELTA_D = 7;
    Aladin aladin;
    ZoomView zoomView;
    private double globalJdmin = Double.NaN;
    private double globalJdmax = Double.NaN;
    int width;
    int height;
    int xDrag;
    int state;
    int stateMove;
    Rectangle inRect = null;
    static final int OUT = 0;
    static final int BEFORE = 1;
    static final int ONSTART = 2;
    static final int INTIME = 3;
    static final int ONEND = 4;
    static final int AFTER = 5;
    static final int INCROSS = 6;
    static final int M = 3;
    private int oldStatMove = -1;
    static final double FCTZOOM = 0.12;
    private static final int W = 4;
    private Rectangle rectCross = null;

    ZoomTime(ZoomView zoomView) {
        this.zoomView = zoomView;
        this.aladin = zoomView.aladin;
        this.xDrag = -1;
        this.state = 0;
        this.stateMove = 0;
    }

    protected boolean mouseIn(int x, int y) {
        return this.inRect == null ? false : this.inRect.contains(x, y);
    }

    protected int getMouseState(int x, int y, ViewSimple v) {
        int end;
        if (this.rectCross != null && this.rectCross.contains(x, y)) {
            return 6;
        }
        double[] t = v.getTimeRange();
        int start = Double.isNaN(t[0]) ? 7 : this.getX(t[0]);
        int n = end = Double.isNaN(t[1]) ? this.width - 7 : this.getX(t[1]);
        return x < 4 ? 0 : (x < start - 3 ? 1 : (x <= start + 3 ? 2 : (x < end - 3 ? 3 : (x <= end + 3 ? 4 : (x <= this.width - 7 + 3 ? 5 : 0)))));
    }

    private double getDeltaTime(int deltaX) {
        double total = this.globalJdmax - this.globalJdmin;
        double w = this.width - 14;
        double onePix = total / w;
        double deltaJD = (double)deltaX * onePix;
        return deltaJD;
    }

    private double getTime(int x) {
        return this.getDeltaTime(x + 7) + this.globalJdmin;
    }

    protected double[] deltaXTime(int deltaX, ViewSimple v) {
        double deltaJD = this.getDeltaTime(deltaX);
        double[] t = v.getTimeRange();
        if (Double.isNaN(t[0])) {
            t[0] = this.globalJdmin;
        }
        if (Double.isNaN(t[1])) {
            t[1] = this.globalJdmax;
        }
        if (this.state == 2) {
            t[0] = t[0] + deltaJD;
        } else if (this.state == 4) {
            t[1] = t[1] + deltaJD;
        } else if (this.state == 3) {
            t[0] = t[0] + deltaJD;
            t[1] = t[1] + deltaJD;
        }
        if (t[0] > t[1]) {
            t[0] = t[1];
        }
        this.aladin.view.setTimeRange(t);
        return t;
    }

    protected double setXTime(int x, ViewSimple v) {
        double jd = this.getTime(x);
        double[] t = v.getTimeRange();
        if (Double.isNaN(t[0]) && Double.isNaN(t[1])) {
            return Double.NaN;
        }
        if (Double.isNaN(t[0])) {
            t[0] = this.globalJdmin;
        }
        if (Double.isNaN(t[1])) {
            t[1] = this.globalJdmax;
        }
        double midRange = (t[1] - t[0]) / 2.0;
        t[0] = jd - midRange;
        t[1] = jd + midRange;
        if (t[0] <= this.globalJdmin) {
            t[0] = Double.NaN;
        }
        if (t[1] >= this.globalJdmax) {
            t[1] = Double.NaN;
        }
        this.aladin.view.setTimeRange(t);
        return midRange;
    }

    protected void mouseMove(int x, int y, ViewSimple v) {
        this.stateMove = !this.mouseIn(x, y) ? 0 : this.getMouseState(x, y, v);
        if (this.oldStatMove != this.stateMove && (this.stateMove == 6 || this.oldStatMove == 6)) {
            this.zoomView.repaint();
        }
        this.oldStatMove = this.stateMove;
    }

    protected boolean mousePress(int x, int y, ViewSimple v, boolean doubleClick) {
        if (!this.mouseIn(x, y)) {
            this.state = 0;
            return false;
        }
        if (doubleClick || this.stateMove == 6) {
            double[] t = new double[]{Double.NaN, Double.NaN};
            this.aladin.view.setTimeRange(t);
            return true;
        }
        this.state = this.getMouseState(x, y, v);
        return true;
    }

    protected boolean mouseDrag(int x, int y, ViewSimple v) {
        if (this.state == 0) {
            return false;
        }
        if (this.xDrag != -1) {
            int deltaX = x - this.xDrag;
            this.deltaXTime(deltaX, v);
        }
        this.xDrag = x;
        return true;
    }

    protected boolean mouseRelease(int x, int y, ViewSimple v) {
        if (this.xDrag != -1) {
            int deltaX = x - this.xDrag;
            double[] t = this.deltaXTime(deltaX, v);
            this.xDrag = -1;
        }
        return true;
    }

    private void dilate(double[] t, double pourcent) {
        double delta = t[1] - t[0];
        double add = delta * (pourcent / 100.0);
        t[0] = t[0] - add;
        t[1] = t[1] + add;
    }

    protected boolean resume() {
        double[] t = this.aladin.view.calque.getGlobalTimeRange();
        if (Double.isNaN(t[0])) {
            t = this.aladin.view.getCurrentView().getTimeRange();
        }
        if (Double.isNaN(t[0])) {
            this.globalJdmin = Double.NaN;
            this.globalJdmax = Double.NaN;
        } else {
            this.dilate(t, 2.0);
            this.globalJdmin = t[0];
            this.globalJdmax = t[1];
        }
        if (Double.isNaN(this.globalJdmin)) {
            return false;
        }
        return this.globalJdmax != this.globalJdmin;
    }

    private int getX(double jd) {
        double total = this.globalJdmax - this.globalJdmin;
        double w = this.width - 14;
        double fct = w / total;
        return (int)((jd - this.globalJdmin) * fct) + 7;
    }

    protected boolean mouseWheelMoved(MouseWheelEvent e, ViewSimple v) {
        if (!this.mouseIn(e.getX(), e.getY())) {
            return false;
        }
        double[] t = v.getTimeRange();
        if (Double.isNaN(t[0])) {
            t = new double[]{this.globalJdmin, this.globalJdmax};
        }
        int sens = e.getWheelRotation() > 0 ? 1 : -1;
        double range = t[1] - t[0];
        double nRange = range * (sens == 1 ? 1.12 : 0.88);
        double centre = (t[0] + t[1]) / 2.0;
        t[0] = centre - nRange / 2.0;
        t[1] = centre + nRange / 2.0;
        boolean rep = this.aladin.view.setTimeRange(t);
        if (rep) {
            this.zoomView.repaint();
        }
        return true;
    }

    private void drawCross(Graphics g, int x, int y) {
        g.setColor(this.stateMove == 6 ? Color.red : Aladin.COLOR_CONTROL_FOREGROUND);
        g.drawLine(x, y, x + 4, y + 4);
        g.drawLine(x + 1, y, x + 4 + 1, y + 4);
        g.drawLine(x + 2, y, x + 4 + 2, y + 4);
        g.drawLine(x + 4, y, x, y + 4);
        g.drawLine(x + 4 + 1, y, x + 1, y + 4);
        g.drawLine(x + 4 + 2, y, x + 2, y + 4);
        this.rectCross = new Rectangle(x - 2, y - 2, 7, 6);
    }

    protected void draw(Graphics g, ViewSimple v) {
        if (!this.resume()) {
            this.inRect = null;
            return;
        }
        this.width = this.zoomView.getWidth();
        this.height = this.zoomView.getHeight();
        int x = 7;
        int y = this.height - 48;
        int w = this.width - 14;
        int MARGE_D = this.width - 7;
        if (this.inRect == null || this.inRect.width != this.width || this.inRect.height != this.height) {
            this.inRect = new Rectangle(x - 2, y - 5, w + 4, 21);
        }
        g.setFont(Aladin.SPLAIN);
        g.setColor(Aladin.COLOR_GREEN);
        g.drawRect(x, y, w, 15);
        g.setColor(Aladin.COLOR_BLUETIME);
        g.fillRect(x + 2, y + 2, w - 4, 11);
        this.rectCross = null;
        double[] t = v.getTimeRange();
        if (!Double.isNaN(t[0]) || !Double.isNaN(t[1])) {
            int lb;
            FontMetrics fm;
            int la;
            int x1 = Double.isNaN(t[0]) ? 7 : this.getX(t[0]);
            int x2 = Double.isNaN(t[1]) ? this.width - 7 : this.getX(t[1]);
            g.setColor(Aladin.COLOR_BLUE);
            int xa = x1 < 7 ? 7 : x1;
            int xb = x2 > this.width - 7 ? this.width - 7 : x2;
            g.fillRect(xa, y + 2, xb - xa + 1, 11);
            if (!Double.isNaN(t[0])) {
                g.setColor(Aladin.COLOR_CONTROL_FOREGROUND_HIGHLIGHT);
                g.fillRect(x1, y - 3, 2, 21);
                g.drawLine(x1, y - 3, x1 + 3, y - 3);
                g.drawLine(x1, y + 15 + 3, x1 + 3, y + 15 + 3);
            }
            if (!Double.isNaN(t[1])) {
                g.fillRect(x2 - 1, y - 3, 2, 21);
                g.drawLine(x2, y - 3, x2 - 3, y - 3);
                g.drawLine(x2, y + 15 + 3, x2 - 3, y + 15 + 3);
            }
            g.setColor(Aladin.COLOR_VERTDEAU);
            String startDate = Astrodate.JDToDate(t[0], false, false);
            String endDate = Astrodate.JDToDate(t[1], false, false);
            if (startDate.equals(endDate)) {
                startDate = Astrodate.JDToDate(t[0]);
                endDate = Astrodate.JDToDate(t[1]);
                int i = endDate.indexOf(84);
                endDate = endDate.substring(i + 1);
            }
            if ((xa = x1 - (la = (fm = g.getFontMetrics()).stringWidth(startDate)) / 2) < 7) {
                xa = 7;
            }
            if (xa + la > (xb = xb + (lb = fm.stringWidth(endDate)) / 2 > MARGE_D ? MARGE_D - lb : x2 - lb / 2)) {
                if (xb + lb >= MARGE_D) {
                    xa = xb - la - 8;
                } else {
                    xb = xa + la + 8;
                }
            }
            g.drawString(startDate, xa, y - 5);
            g.drawString(endDate, xb, y - 5);
            if (!v.isPlotTime()) {
                this.drawCross(g, x2 - 10, y + 5);
            }
            g.setColor(Aladin.COLOR_CONTROL_FOREGROUND_HIGHLIGHT);
            if (Double.isNaN(t[0])) {
                t[0] = this.globalJdmin;
            }
            if (Double.isNaN(t[1])) {
                t[1] = this.globalJdmax;
            }
            String s = Util.getTemps((long)((t[1] - t[0]) * 8.64E10));
            int len = g.getFontMetrics().stringWidth(s);
            int x3 = (x2 + x1) / 2 - len / 2;
            if (x3 > x1 && x3 > 7 && x3 + len < x2 && x2 + len < MARGE_D) {
                g.drawString(s, x3, y + 15 - 2);
            }
        } else {
            g.setColor(this.stateMove == 2 ? Aladin.COLOR_CONTROL_FOREGROUND : Aladin.COLOR_GREEN);
            Util.drawTriangle(g, 7, y - 2, 7, false);
            g.setColor(this.stateMove == 4 ? Aladin.COLOR_CONTROL_FOREGROUND : Aladin.COLOR_GREEN);
            Util.drawTriangle(g, MARGE_D, y - 2, 7, false);
        }
    }
}

